// ==========================================================================
//
// = LIBRARY
//     PCIEFPGA
// 
// = FILENAME
//     PCIeFPGAcsmis.cpp
// 
// = COPYRIGHT
//     (C) Copyright 2010 Agilent Technologies
//
// ==========================================================================

#include "PCIeFPGAcsmis.h"
#include "devpcieintdefs.h"
#include "AgtPCIEControl.h"

CPCIEFpgaCSMis::CPCIEFpgaCSMis()
{
  mExerciserMode = PCIE_FPGA_CSMIS_OFFSET + 0x074;

  myController = new CAgtPCIEControl(); // returns only pointer if instance exists
}

CPCIEFpgaCSMis::~CPCIEFpgaCSMis()
{
  delete myController;
  myController = NULL;
}

UInt32 CPCIEFpgaCSMis::getExerciserMode( const AgtPortHandleT& portHandle )
{
  UInt32 val;

  myController->FPGARead( portHandle, mExerciserMode, val );

  return val;
}